"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const fs_1 = require("fs");
async function bootstrap() {
    const httpsOptions = {
        key: (0, fs_1.readFileSync)('/home/autonomadeica/ssl/keys/c000b_66af5_a6a8816b80e5db8f454a05810921535f.key'),
        cert: (0, fs_1.readFileSync)('/home/autonomadeica/ssl/certs/data_autonomadeica_edu_pe_c000b_66af5_1747818961_ab946243d7c29ea22814a7c9a5a7d3b5.crt'),
    };
    const app = await core_1.NestFactory.create(app_module_1.AppModule, { httpsOptions });
    app.enableCors({
        origin: '*',
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
        credentials: true,
    });
    app.setGlobalPrefix('api');
    console.log('Backend corriendo en el puerto: ', process.env.PORT);
    await app.listen(process.env.PORT ?? 3000);
}
bootstrap();
//# sourceMappingURL=main.js.map