"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurlleService = void 0;
const common_1 = require("@nestjs/common");
const curlle_entity_1 = require("./entities/curlle.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
let CurlleService = class CurlleService {
    constructor(curlleRepository, dataSource) {
        this.curlleRepository = curlleRepository;
        this.dataSource = dataSource;
        this.logger = new common_1.Logger('LocalesService');
    }
    create(createCurlleDto) {
        return 'This action adds a new curlle';
    }
    async findAll(codigo) {
        const query = `
      SELECT 
        notas.codalu,
        notas.codper,
        plan.c_ciclo,
        plan.n_ciclo,
        notas.codcur,
        plan.c_nomcur,
        notas.cargo,
        notas.notcurlle,
        notas.cnotcurlle,
        notas.user_name,
        notas.user_fech,
        notas.tar,
        notas.curs_conva,
        notas.reso_conva,
        notas.periodo,
        notas.numcred,
        notas.d_fecha,
        notas.n_cicper,
        notas.nota_sub,
        notas.reso_sub,
        notas.cndcurlle,
        notas.id,
        notas.n_codpla,
        notas.c_grpcur,
        notas.c_codfac,
        notas.c_codesp,
        notas.c_codfac_alu,
        notas.c_codesp_alu,
        notas.c_estado_conv,
        notas.nota_conv_tmp
      FROM curlle notas
      INNER JOIN tb_plan_estudio_curso plan
      ON notas.c_codesp = plan.c_codesp 
      AND notas.n_codpla = plan.n_codper 
      AND notas.codcur = plan.c_codcur
      WHERE notas.codalu = $1
      ORDER BY notas.codalu, notas.codper, plan.n_ciclo, notas.codcur
    `;
        return await this.dataSource.query(query, [codigo]);
    }
    async findOne(codigo) {
        const query = `
      SELECT 
        notas.codalu,
        notas.codper,
        plan.c_ciclo,
        plan.n_ciclo,
        notas.codcur,
        plan.c_nomcur,
        notas.cargo,
        notas.notcurlle,
        notas.cnotcurlle,
        notas.user_name,
        notas.user_fech,
        notas.tar,
        notas.curs_conva,
        notas.reso_conva,
        notas.periodo,
        notas.numcred,
        notas.d_fecha,
        notas.n_cicper,
        notas.nota_sub,
        notas.reso_sub,
        notas.cndcurlle,
        notas.id,
        notas.n_codpla,
        notas.c_grpcur,
        notas.c_codfac,
        notas.c_codesp,
        notas.c_codfac_alu,
        notas.c_codesp_alu,
        notas.c_estado_conv,
        notas.nota_conv_tmp
      FROM curlle notas
      INNER JOIN tb_plan_estudio_curso plan
      ON notas.c_codesp = plan.c_codesp 
      AND notas.n_codpla = plan.n_codper 
      AND notas.codcur = plan.c_codcur
      WHERE notas.codalu = ?
      ORDER BY notas.codalu, notas.codper, plan.n_ciclo, notas.codcur
    `;
        try {
            return await this.dataSource.query(query, [codigo]);
        }
        catch (error) {
            this.HandleDBExceptions(error);
        }
    }
    update(id, updateCurlleDto) {
        return `This action updates a #${id} curlle`;
    }
    remove(id) {
        return `This action removes a #${id} curlle`;
    }
    HandleDBExceptions(error) {
        if (error.code === '23505')
            throw new common_1.BadRequestException(error.detail);
        this.logger.error(error);
        throw new common_1.InternalServerErrorException('Unexpected error, check server log');
    }
};
exports.CurlleService = CurlleService;
exports.CurlleService = CurlleService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(curlle_entity_1.Curlle)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.DataSource])
], CurlleService);
//# sourceMappingURL=curlle.service.js.map